function inputGUI
close all

% Create instructions figure
g.f = figure('toolbar','none','menu','none','units','pixels',...
    'position',[0,0,550,580], 'name','Instructions');
movegui(g.f,'west')

% Introduction
h.t(1) = uicontrol('style','text','units','pixels',...
    'position',[15,450,510,120], 'HorizontalAlignment','Left');
intro = sprintf('The Spectral Imaging Toolbox provides convenient spectral analysis for a directory of 3D or 4D spectral image stacks and provides a semi-automated method for reliable membrane segmentation. Output includes a results summary spreadsheet (.xlsx), pseudocolored generalized polarization (GP) maps, 3D reconstruction of GP maps for z-stacks, GP histograms, GP data (including GP values, mean, std, median, and number of pixels), spectra, regionprops (see regionprops in MATLAB docs), size distribution histograms (spherical object mode only), and circle detection overlays (spherical object mode only) for each image/object/membrane.');
set(h.t(1),'String',intro)

% Instructions
h.t(1) = uicontrol('style','text','units','pixels',...
    'position',[15,0,510,460], 'HorizontalAlignment','Left');
instructions = sprintf('Select the segmentation mode from the following: \n1. Objects and membranes: Objects are individually cropped using thresholding, connected-component labelling, and watershed or lasso segmentation methods. Membranes are then segmented from the cropped objects\n2. Objects only: Objects are individually cropped using thresholding, connected-component labelling, and watershed or lasso segmentation methods\n3. Spherical objects: Objects are segmented using a circle-finding algorithm\n4. No segmentation: No segmentation is performed\nTo use both single and two-term Gaussian fitting of GP histograms, check the associated checkbox. If unchecked, only single peak Gaussians will be used for fitting.\nIf a GP correction factor, G, is required, enter the GP of the reference solution as measured by a fluorometer. Then enter the full path (or browse by clicking load reference image) to an image of the same reference solution taken with the microscope gain and filter settings used for experiments. If G is not needed for GP calculations, leave these fields blank.\nSpecify low and high wavelengths for Generalized Polarization (GP) calculations.\nSpecify input and output directories by clicking the buttons to browse or by manually entering full paths. The input directory must contain only images in ome-compatible formats and no other files (subdirectories are ignored). Inputs must be spectral images (stacks of images acquired at multiple detection wavelengths). 4D spectral z-stacks and 4D time-series spectral stacks work as well.');
set(h.t(1),'String',instructions)

% Create GUI
h.f = figure('toolbar','none','menu','none','units','pixels',...
    'position',[0,0,550,500], 'name','Spectral Imaging Toolbox');
movegui(h.f,'center')

% Segmentation options
bg = uibuttongroup(); 
h.c(1) = uicontrol(bg, 'style','radiobutton','units','pixels',...
    'position',[10,430,500,15], 'Value',1, 'string','Objects and membranes');
h.c(2) = uicontrol(bg, 'style','radiobutton','units','pixels',...
    'position',[10,400,500,15],'Value',0, 'string','Objects only');
h.c(3) = uicontrol(bg, 'style','radiobutton','units','pixels',...
    'position',[200,430,500,15], 'Value',0, 'string','Spherical objects');
h.c(4) = uicontrol(bg, 'style','radiobutton','units','pixels',...
    'position',[200,400,500,15],'Value',0, 'string','No segmentation');
h.t(2) = uicontrol('style','text','units','pixels',...
    'position',[10,450,500,20],'string','Segmentation options:', 'HorizontalAlignment','Left');

% Allow two-term Gaussian fitting of GP histograms?
h.t(8) = uicontrol('style','text','units','pixels',...
    'position',[10,360,500,20],'string','Allow two-term Gaussian fitting of GP histograms? Uncheck for single peak only.', 'HorizontalAlignment','Left');
h.c(9) = uicontrol('style','checkbox','units','pixels',...
    'position',[10,340,100,20], 'Value', 0);

% GP correction factor
h.t(3) = uicontrol('style','text','units','pixels',...
    'position',[10,300,500,20],'string','Optional: If using a GP correction factor, specify reference GP measured by fluorometer', 'HorizontalAlignment','Left');

h.c(5) = uicontrol('style','edit','units','pixels',...
    'position',[10,280,100,20]);

h.t(4) = uicontrol('style','text','units','pixels',...
    'position',[10,245,500,20],'string','Optional: If using a GP correction factor, specify full path to spectral image of the reference solution', 'HorizontalAlignment','Left');

h.p(2) = uicontrol('style','pushbutton','units','pixels',...
    'position',[370,225,150,20],'string','load reference image',...
    'callback',@p_refLoader);

h.c(8) = uicontrol('style','edit','units','pixels',...
    'position',[10,225,350,20], 'HorizontalAlignment', 'left');

 function p_refLoader(varargin)
     [filename, pathname, ~] = uigetfile('..\*.*'); 
     refIm = [pathname filename];
     set(h.c(8),'String',refIm);
 end

% Wavelengths for GP calculation
h.t(5) = uicontrol('style','text','units','pixels',...
    'position',[10,180,500,20],'string','Specify wavelengths for GP calculation:', 'HorizontalAlignment','Left');

h.t(6) = uicontrol('style','text','units','pixels',...
    'position',[80 155 150 20],'string','Wavelength low:');

h.t(7) = uicontrol('style','text','units','pixels',...
    'position',[305 155 150 20],'string','Wavelength high:');

lambdaLow = uicontrol('Style', 'edit','Position', [105 135 100 20]);
lambdaHigh = uicontrol('Style', 'edit','Position', [330 135 100 20]);

% Input directory
h.p(4) = uicontrol('style','pushbutton','units','pixels',...
    'position',[370,90,150,20],'string','Browse input directory',...
    'callback',@p_input);

h.c(6) = uicontrol('style','edit','units','pixels',...
    'position',[10,90,350,20], 'HorizontalAlignment', 'left');

 function p_input(varargin)
     inputDir = uigetdir; 
     set(h.c(6),'String',inputDir);
 end

% Output directory
h.p(3) = uicontrol('style','pushbutton','units','pixels',...
    'position',[370,55,150,20],'string','Browse output directory',...
    'callback',@p_output);

h.c(7) = uicontrol('style','edit','units','pixels',...
    'position',[10,55,350,20], 'HorizontalAlignment', 'left');

function p_output(varargin)
     outputDir = uigetdir; 
     set(h.c(7),'String',outputDir);
end

% Start button
h.p(5) = uicontrol('style','pushbutton','units','pixels',...
    'position',[10,20,70,20],'string','OK',...
    'callback',@p_params);

function p_params(varargin)
    options = get(h.c(1:4),'Value');
    options = find([options{:}]);
    GPref = str2double(get(h.c(5),'String'));
    inputDir = get(h.c(6),'String');
    outputDir = get(h.c(7),'String');
    refIm = get(h.c(8),'String');
    twoTerm = get(h.c(9),'Value');
    lambdas(1,1) = str2double(get(lambdaLow,'String'));
    lambdas(2,1) = str2double(get(lambdaHigh,'String'));
    assignin('base', 'options', options) 
    assignin('base', 'GPref', GPref) 
    assignin('base', 'refIm', refIm) 
    assignin('base', 'twoTerm', twoTerm) 
    assignin('base', 'lambdas', lambdas) 
    assignin('base', 'inputDir', inputDir) 
    assignin('base', 'outputDir', outputDir) 
    close all
end

end